import { Check, X } from "lucide-react";

export function Comparison() {
  return (
    <section className="py-24 bg-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <h2 className="text-4xl font-display font-bold text-foreground mb-4">
            Why Choose <span className="text-primary">Lumi Care</span>?
          </h2>
          <p className="text-muted-foreground">See how we stack up against other apps.</p>
        </div>

        <div className="max-w-4xl mx-auto rounded-[2rem] border border-gray-100 shadow-2xl overflow-hidden bg-white">
          <div className="grid grid-cols-3 bg-gray-50/50 p-6 border-b border-gray-100">
            <div className="font-bold text-gray-400 uppercase text-xs tracking-wider pt-2">Feature</div>
            <div className="text-center font-display font-bold text-2xl text-primary">Lumi Care</div>
            <div className="text-center font-bold text-gray-400 text-lg pt-1">Others</div>
          </div>

          {[
            { feature: "AI Acne Detector", lumi: true, other: false, label: "Paid" },
            { feature: "Water Tracking", lumi: true, other: true, label: "Yes" },
            { feature: "Face Massage Guides", lumi: true, other: false, label: "No" },
            { feature: "Community Support", lumi: true, other: false, label: "Limited" },
            { feature: "Courses & Challenges", lumi: true, other: false, label: "Paid" },
            { feature: "Ads Overload", lumi: false, other: true, label: "Too Many" },
          ].map((row, idx) => (
            <div key={idx} className="grid grid-cols-3 p-6 border-b border-gray-50 hover:bg-gray-50 transition-colors items-center">
              <div className="font-medium text-gray-700">{row.feature}</div>
              
              <div className="flex justify-center">
                {row.lumi ? (
                  <div className="w-8 h-8 rounded-full bg-green-100 flex items-center justify-center text-green-600">
                    <Check size={20} strokeWidth={3} />
                  </div>
                ) : (
                  <span className="text-sm font-medium text-gray-500">Minimal</span>
                )}
              </div>
              
              <div className="flex justify-center">
                {row.other ? (
                  row.label === "Yes" ? (
                    <div className="w-8 h-8 rounded-full bg-gray-100 flex items-center justify-center text-gray-400">
                      <Check size={20} />
                    </div>
                  ) : (
                     <span className="text-sm text-gray-400">{row.label}</span>
                  )
                ) : (
                  <div className="w-8 h-8 rounded-full bg-red-50 flex items-center justify-center text-red-300">
                    <X size={20} />
                  </div>
                )}
              </div>
            </div>
          ))}
          
          <div className="p-8 text-center bg-[#FFF5F5]">
            <p className="text-primary font-bold mb-4">Ready to start your journey?</p>
            <button 
              className="px-8 py-3 bg-primary text-white font-bold rounded-full shadow-lg hover:shadow-xl transition-all hover:scale-105"
              onClick={() => window.open("https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp", "_blank")}
            >
              Get Started Free
            </button>
          </div>
        </div>
      </div>
    </section>
  );
}
