import { 
  Droplets, 
  ScanFace, 
  MessageCircleHeart, 
  Sparkles, 
  BookOpen, 
  Dumbbell 
} from "lucide-react";
import { motion } from "framer-motion";

const features = [
  {
    icon: Droplets,
    title: "Water Tracking",
    description: "Daily hydration reminders customized for your body and skin goals.",
    color: "bg-blue-100 text-blue-600",
  },
  {
    icon: ScanFace,
    title: "AI Acne Detector",
    description: "Scan your skin to understand triggers and get personalized advice instantly.",
    color: "bg-pink-100 text-pink-600",
  },
  {
    icon: MessageCircleHeart,
    title: "Community Chat",
    description: "Connect with real people on the same journey. Share tips, support, and wins.",
    color: "bg-purple-100 text-purple-600",
  },
  {
    icon: Sparkles,
    title: "Face Massage",
    description: "Free guided massage routines for acne relief, glow, and relaxation.",
    color: "bg-amber-100 text-amber-600",
  },
  {
    icon: BookOpen,
    title: "Daily Skin Tips",
    description: "Bite-sized advice from experts to help you build better long-term habits.",
    color: "bg-green-100 text-green-600",
  },
  {
    icon: Dumbbell,
    title: "Glow Challenges",
    description: "Exercise challenges designed to boost circulation and skin health from within.",
    color: "bg-rose-100 text-rose-600",
  },
];

export function Features() {
  return (
    <section id="features" className="py-24 bg-white relative">
      <div className="container mx-auto px-4">
        <div className="text-center max-w-3xl mx-auto mb-16">
          <h2 className="text-4xl md:text-5xl font-display font-bold text-foreground mb-4">
            Everything You Need for <span className="text-primary">Glowing Skin</span>
          </h2>
          <p className="text-lg text-muted-foreground">
            We combined technology with holistic wellness to give you the most complete skincare companion.
          </p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {features.map((feature, idx) => (
            <motion.div
              key={idx}
              initial={{ opacity: 0, y: 20 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ delay: idx * 0.1 }}
              className="group p-8 rounded-3xl border border-gray-100 bg-background hover:bg-white hover:shadow-xl transition-all duration-300 hover:-translate-y-1"
            >
              <div className={`w-14 h-14 rounded-2xl ${feature.color} flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300`}>
                <feature.icon size={28} />
              </div>
              <h3 className="text-xl font-bold text-foreground mb-3">{feature.title}</h3>
              <p className="text-muted-foreground leading-relaxed">
                {feature.description}
              </p>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
  );
}
