import { motion } from "framer-motion";
import { ArrowRight, Droplets, Sparkles, Smartphone } from "lucide-react";
import { Button } from "@/components/ui/button";

export function Hero() {
  return (
    <section className="relative pt-32 pb-20 lg:pt-48 lg:pb-32 overflow-hidden bg-gradient-to-b from-[#FFF5F5] to-background">
      {/* Decorative blobs */}
      <div className="absolute top-0 right-0 w-[500px] h-[500px] bg-primary/5 rounded-full blur-3xl -translate-y-1/2 translate-x-1/2" />
      <div className="absolute bottom-0 left-0 w-[500px] h-[500px] bg-secondary/30 rounded-full blur-3xl translate-y-1/2 -translate-x-1/2" />

      <div className="container mx-auto px-4 relative z-10">
        <div className="flex flex-col lg:flex-row items-center gap-12 lg:gap-20">
          
          {/* Text Content */}
          <motion.div 
            initial={{ opacity: 0, y: 20 }}
            animate={{ opacity: 1, y: 0 }}
            transition={{ duration: 0.8, ease: "easeOut" }}
            className="lg:w-1/2 text-center lg:text-left"
          >
            <div className="inline-flex items-center gap-2 px-4 py-2 rounded-full bg-white border border-border shadow-sm mb-6">
              <Sparkles className="w-4 h-4 text-primary" />
              <span className="text-sm font-medium text-muted-foreground">#1 Free Skin Care Tracker</span>
            </div>
            
            <h1 className="text-5xl lg:text-7xl font-display font-bold text-foreground leading-[1.1] mb-6">
              Clear Skin. <br/>
              <span className="text-primary italic">Better Habits.</span> <br/>
              Real Results.
            </h1>
            
            <p className="text-lg lg:text-xl text-muted-foreground mb-8 max-w-xl mx-auto lg:mx-0 leading-relaxed">
              Track water, detect acne, follow free skin routines, and join a supportive beauty community — all in one free app.
            </p>
            
            <div className="flex flex-col sm:flex-row items-center justify-center lg:justify-start gap-4">
              <Button 
                size="lg"
                className="w-full sm:w-auto h-14 px-8 rounded-full text-lg bg-primary hover:bg-primary/90 shadow-xl shadow-primary/25 hover:shadow-2xl hover:shadow-primary/30 transition-all hover:-translate-y-1"
                onClick={() => window.open("https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp", "_blank")}
              >
                Get Free Acne Detector <ArrowRight className="ml-2 w-5 h-5" />
              </Button>
              
              <Button 
                size="lg"
                variant="outline"
                className="w-full sm:w-auto h-14 px-8 rounded-full text-lg border-2 border-primary/20 hover:bg-primary/5 hover:border-primary/40 text-foreground transition-all"
                onClick={() => document.getElementById('challenges')?.scrollIntoView({ behavior: 'smooth' })}
              >
                <Droplets className="mr-2 w-5 h-5 text-blue-400" />
                Hydration Challenge
              </Button>
            </div>

            <div className="mt-8 flex items-center justify-center lg:justify-start gap-2 text-sm text-muted-foreground font-medium">
              <div className="flex -space-x-2">
                {[1, 2, 3, 4].map((i) => (
                  <div key={i} className="w-8 h-8 rounded-full border-2 border-white bg-gray-200 overflow-hidden">
                    {/* Unsplash abstract avatar replacement */}
                    <img src={`https://api.dicebear.com/7.x/avataaars/svg?seed=${i}`} alt="User" />
                  </div>
                ))}
              </div>
              <span>Join 50,000+ happy users</span>
            </div>
          </motion.div>

          {/* Hero Image / Mockup */}
          <motion.div 
            initial={{ opacity: 0, scale: 0.95 }}
            animate={{ opacity: 1, scale: 1 }}
            transition={{ duration: 1, delay: 0.2 }}
            className="lg:w-1/2 relative"
          >
            <div className="relative mx-auto w-[300px] h-[600px] bg-gray-900 rounded-[3rem] border-8 border-gray-900 shadow-2xl overflow-hidden animate-float">
              {/* Screen Content */}
              <div className="absolute top-0 left-0 w-full h-full bg-white">
                 {/* Status Bar */}
                 <div className="h-6 w-full bg-white flex justify-between px-6 items-center pt-2">
                   <div className="text-[10px] font-bold">9:41</div>
                   <div className="flex gap-1">
                     <div className="w-3 h-3 bg-black rounded-full"></div>
                     <div className="w-3 h-3 bg-black rounded-full"></div>
                   </div>
                 </div>

                 {/* App UI Header */}
                 <div className="p-6 bg-[#FFF5F5]">
                   <h3 className="font-display text-2xl font-bold text-gray-800">Hello, Sarah! ✨</h3>
                   <p className="text-sm text-gray-500">Your skin looks glowing today.</p>
                 </div>

                 {/* App UI Cards */}
                 <div className="p-4 space-y-4">
                   <div className="bg-blue-50 p-4 rounded-2xl border border-blue-100 flex items-center gap-4">
                     <div className="w-10 h-10 rounded-full bg-blue-100 flex items-center justify-center text-blue-500">
                       <Droplets size={20} />
                     </div>
                     <div>
                       <h4 className="font-bold text-gray-800">Water Tracker</h4>
                       <p className="text-xs text-gray-500">1.2L / 2.5L Goal</p>
                     </div>
                   </div>

                   <div className="bg-pink-50 p-4 rounded-2xl border border-pink-100 flex items-center gap-4">
                     <div className="w-10 h-10 rounded-full bg-pink-100 flex items-center justify-center text-pink-500">
                       <Smartphone size={20} />
                     </div>
                     <div>
                       <h4 className="font-bold text-gray-800">Acne Scan</h4>
                       <p className="text-xs text-gray-500">No active breakouts detected</p>
                     </div>
                   </div>

                   {/* Graph Placeholder */}
                   <div className="bg-white p-4 rounded-2xl border shadow-sm">
                      <h4 className="font-bold text-gray-800 mb-2">Skin Progress</h4>
                      <div className="flex items-end gap-2 h-24 pb-2">
                        <div className="flex-1 bg-gray-100 rounded-t-md h-[40%]"></div>
                        <div className="flex-1 bg-gray-100 rounded-t-md h-[60%]"></div>
                        <div className="flex-1 bg-primary/20 rounded-t-md h-[50%]"></div>
                        <div className="flex-1 bg-primary/40 rounded-t-md h-[70%]"></div>
                        <div className="flex-1 bg-primary rounded-t-md h-[85%]"></div>
                      </div>
                   </div>
                 </div>
              </div>
            </div>
            
            {/* Floating Badge 1 */}
            <motion.div 
              initial={{ x: -20, opacity: 0 }}
              animate={{ x: 0, opacity: 1 }}
              transition={{ delay: 0.8 }}
              className="absolute top-20 -left-12 bg-white p-4 rounded-2xl shadow-xl flex items-center gap-3 border border-gray-100"
            >
              <div className="bg-green-100 p-2 rounded-full text-green-600">
                <Sparkles size={18} />
              </div>
              <div>
                <p className="font-bold text-sm text-gray-800">Skin Analysis</p>
                <p className="text-xs text-gray-500">98% Accuracy</p>
              </div>
            </motion.div>

            {/* Floating Badge 2 */}
            <motion.div 
              initial={{ x: 20, opacity: 0 }}
              animate={{ x: 0, opacity: 1 }}
              transition={{ delay: 1 }}
              className="absolute bottom-40 -right-8 bg-white p-4 rounded-2xl shadow-xl flex items-center gap-3 border border-gray-100"
            >
              <div className="bg-blue-100 p-2 rounded-full text-blue-600">
                <Droplets size={18} />
              </div>
              <div>
                <p className="font-bold text-sm text-gray-800">Daily Hydration</p>
                <p className="text-xs text-gray-500">Streak: 12 Days 🔥</p>
              </div>
            </motion.div>
          </motion.div>
        </div>
      </div>
    </section>
  );
}
