import { useState, useEffect } from "react";
import { Link } from "wouter";
import { Menu, X } from "lucide-react";
import { Button } from "@/components/ui/button";

export function Navigation() {
  const [isScrolled, setIsScrolled] = useState(false);
  const [mobileMenuOpen, setMobileMenuOpen] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      setIsScrolled(window.scrollY > 20);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  const scrollToSection = (id: string) => {
    setMobileMenuOpen(false);
    const element = document.getElementById(id);
    if (element) {
      element.scrollIntoView({ behavior: "smooth" });
    }
  };

  return (
    <nav
      className={`fixed top-0 left-0 right-0 z-50 transition-all duration-300 ${
        isScrolled
          ? "bg-white/90 backdrop-blur-md shadow-sm py-3"
          : "bg-transparent py-5"
      }`}
    >
      <div className="container mx-auto px-4 flex items-center justify-between">
        <Link href="/" className="flex items-center gap-2 z-50">
          {/* Logo Icon */}
          <div className="w-8 h-8 rounded-full bg-gradient-to-tr from-primary to-primary/60 flex items-center justify-center text-white font-serif font-bold text-lg">
            L
          </div>
          <span className="text-2xl font-display font-bold text-foreground tracking-tight">
            Lumi Care
          </span>
        </Link>

        {/* Desktop Menu */}
        <div className="hidden md:flex items-center gap-8">
          <button onClick={() => scrollToSection("features")} className="text-sm font-medium hover:text-primary transition-colors">
            Features
          </button>
          <button onClick={() => scrollToSection("challenges")} className="text-sm font-medium hover:text-primary transition-colors">
            Free Challenges
          </button>
          <button onClick={() => scrollToSection("testimonials")} className="text-sm font-medium hover:text-primary transition-colors">
            Reviews
          </button>
          <Button 
            className="rounded-full px-6 bg-primary hover:bg-primary/90 text-white font-medium shadow-lg shadow-primary/20 hover:shadow-xl hover:shadow-primary/30 transition-all hover:-translate-y-0.5"
            onClick={() => window.open("https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp", "_blank")}
          >
            Get App Free
          </Button>
        </div>

        {/* Mobile Menu Toggle */}
        <div className="md:hidden z-50">
          <button
            onClick={() => setMobileMenuOpen(!mobileMenuOpen)}
            className="p-2 text-foreground"
          >
            {mobileMenuOpen ? <X /> : <Menu />}
          </button>
        </div>

        {/* Mobile Menu Overlay */}
        {mobileMenuOpen && (
          <div className="fixed inset-0 bg-background/95 backdrop-blur-sm z-40 flex flex-col items-center justify-center gap-8 md:hidden">
            <button onClick={() => scrollToSection("features")} className="text-xl font-display font-medium">
              Features
            </button>
            <button onClick={() => scrollToSection("challenges")} className="text-xl font-display font-medium">
              Free Challenges
            </button>
            <button onClick={() => scrollToSection("testimonials")} className="text-xl font-display font-medium">
              Reviews
            </button>
            <Button 
              className="rounded-full w-48 text-lg py-6 bg-primary hover:bg-primary/90 text-white shadow-xl"
              onClick={() => window.open("https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp", "_blank")}
            >
              Get App Free
            </Button>
          </div>
        )}
      </div>
    </nav>
  );
}
