import { useState } from "react";
import { useCreateSubscriber } from "@/hooks/use-subscribers";
import { Button } from "@/components/ui/button";
import { Input } from "@/components/ui/input";
import { Loader2, Mail } from "lucide-react";

export function Newsletter() {
  const [email, setEmail] = useState("");
  const createSubscriber = useCreateSubscriber();

  const handleSubmit = (e: React.FormEvent) => {
    e.preventDefault();
    if (!email) return;
    createSubscriber.mutate({ email }, {
      onSuccess: () => setEmail("")
    });
  };

  return (
    <section className="py-20 px-4">
      <div className="max-w-4xl mx-auto bg-primary rounded-[2.5rem] p-8 md:p-16 text-center text-white relative overflow-hidden shadow-2xl">
        {/* Decorative Circles */}
        <div className="absolute top-0 left-0 w-64 h-64 bg-white/10 rounded-full -translate-x-1/2 -translate-y-1/2 blur-2xl" />
        <div className="absolute bottom-0 right-0 w-64 h-64 bg-white/10 rounded-full translate-x-1/2 translate-y-1/2 blur-2xl" />

        <div className="relative z-10">
          <Mail className="w-12 h-12 mx-auto mb-6 text-white/80" />
          <h2 className="text-3xl md:text-5xl font-display font-bold mb-4">
            Get Weekly Skin Tips
          </h2>
          <p className="text-white/80 text-lg mb-8 max-w-xl mx-auto">
            Join our community newsletter for exclusive tips, challenge announcements, and glow-up guides.
          </p>

          <form onSubmit={handleSubmit} className="flex flex-col sm:flex-row gap-4 max-w-md mx-auto">
            <Input
              type="email"
              placeholder="Enter your email"
              value={email}
              onChange={(e) => setEmail(e.target.value)}
              className="bg-white/10 border-white/20 text-white placeholder:text-white/50 h-12 rounded-xl focus:bg-white/20 transition-all backdrop-blur-sm"
              required
            />
            <Button 
              type="submit" 
              disabled={createSubscriber.isPending}
              className="bg-white text-primary hover:bg-white/90 font-bold h-12 px-8 rounded-xl shadow-lg transition-all"
            >
              {createSubscriber.isPending ? <Loader2 className="w-4 h-4 animate-spin" /> : "Subscribe"}
            </Button>
          </form>
          
          <p className="text-xs text-white/50 mt-4">
            No spam, ever. Unsubscribe anytime.
          </p>
        </div>
      </div>
    </section>
  );
}
