import { Navigation } from "@/components/Navigation";
import { Hero } from "@/components/Hero";
import { Features } from "@/components/Features";
import { Challenges } from "@/components/Challenges";
import { Comparison } from "@/components/Comparison";
import { Testimonials } from "@/components/Testimonials";
import { FAQ } from "@/components/FAQ";
import { Newsletter } from "@/components/Newsletter";
import { Footer } from "@/components/Footer";
import { Button } from "@/components/ui/button";
import { ArrowDown } from "lucide-react";
import { useState, useEffect } from "react";
import { AnimatePresence, motion } from "framer-motion";

export default function Home() {
  const [showSticky, setShowSticky] = useState(false);

  useEffect(() => {
    const handleScroll = () => {
      // Show sticky button after scrolling past hero (approx 600px)
      setShowSticky(window.scrollY > 600);
    };
    window.addEventListener("scroll", handleScroll);
    return () => window.removeEventListener("scroll", handleScroll);
  }, []);

  return (
    <div className="min-h-screen font-sans selection:bg-primary/20">
      <Navigation />
      
      <main>
        <Hero />
        <Features />
        <Challenges />
        <Comparison />
        <Testimonials />
        <FAQ />
        <Newsletter />
      </main>

      <Footer />

      {/* Sticky Mobile CTA */}
      <AnimatePresence>
        {showSticky && (
          <motion.div 
            initial={{ y: 100 }}
            animate={{ y: 0 }}
            exit={{ y: 100 }}
            className="fixed bottom-6 left-4 right-4 z-40 md:hidden"
          >
            <Button 
              className="w-full h-14 rounded-full bg-primary text-white shadow-xl shadow-primary/30 font-bold text-lg"
              onClick={() => window.open("https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp", "_blank")}
            >
              Install App - Free
              <ArrowDown className="ml-2 w-5 h-5 animate-bounce" />
            </Button>
          </motion.div>
        )}
      </AnimatePresence>
    </div>
  );
}
