# Lumi Care - Deployment Guide

## Download & Setup

### Step 1: Extract the Archive
```bash
# If you downloaded the .tar.gz file
tar -xzf lumi-care-landing.tar.gz
cd lumi-care-landing

# Or if you cloned from GitHub, just navigate to the project
cd lumi-care-landing
```

### Step 2: Install Dependencies
```bash
npm install
```

### Step 3: Build for Production
```bash
npm run build
```

---

## Deploy to Netlify

### Option A: Using Netlify CLI (Recommended)

1. **Install Netlify CLI**
   ```bash
   npm install -g netlify-cli
   ```

2. **Login to Netlify**
   ```bash
   netlify login
   ```

3. **Deploy**
   ```bash
   netlify deploy --prod
   ```

### Option B: Using Netlify Web Dashboard

1. **Push to GitHub**
   ```bash
   git init
   git add .
   git commit -m "Initial commit"
   git remote add origin https://github.com/YOUR_USERNAME/lumi-care-landing.git
   git push -u origin main
   ```

2. **Create New Site on Netlify**
   - Go to [netlify.com](https://netlify.com)
   - Click "New site from Git"
   - Select your GitHub repository
   - Build command: `npm run build`
   - Publish directory: `dist`
   - Click "Deploy site"

### Option C: Using Netlify Drag & Drop

1. **Build the project**
   ```bash
   npm run build
   ```

2. **Go to [Netlify](https://netlify.com)**
   - Drag & drop the `dist` folder into the drop zone
   - Your site will be deployed instantly!

---

## Environment Variables

The landing page is static and doesn't require environment variables for basic functionality. However, if you want to enable the email subscription feature (Newsletter component), you'll need a database backend.

### For Email Subscriptions

1. Set up a backend service (you can host on:
   - Heroku
   - Railway
   - Render
   - AWS Lambda
   - Or keep using Replit)

2. Update the API endpoint in your code or environment:
   ```
   VITE_API_URL=https://your-backend-url.com
   ```

3. In Netlify dashboard:
   - Go to Site Settings → Build & Deploy → Environment
   - Add `VITE_API_URL` variable with your backend URL

---

## Project Structure

```
lumi-care-landing/
├── client/              # Frontend React/Vite app
│   ├── src/
│   │   ├── components/  # Reusable UI components
│   │   ├── pages/       # Page components
│   │   └── App.tsx      # Main app component
│   ├── index.html
│   └── vite.config.ts
├── server/              # Backend (optional for email subscriptions)
├── shared/              # Shared types & schemas
├── package.json
├── tailwind.config.ts
├── vite.config.ts
└── netlify.toml         # Netlify configuration
```

---

## Customization

### Change Colors
Edit `client/src/index.css` - Look for the CSS variables in the `:root` section

### Update Content
All page content is in `client/src/components/`:
- `Hero.tsx` - Main headline and CTA
- `Features.tsx` - App features grid
- `Challenges.tsx` - Free challenges section
- `Comparison.tsx` - Feature comparison table
- `FAQ.tsx` - FAQ section
- `Testimonials.tsx` - User testimonials
- `Newsletter.tsx` - Email signup

### Update Play Store Link
Search for `https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp` in the code and update with your own app ID.

---

## Troubleshooting

### Build fails with "Cannot find module"
```bash
# Clear cache and reinstall
rm -rf node_modules package-lock.json
npm install
```

### Netlify deployment fails
1. Check build logs in Netlify dashboard
2. Ensure `npm run build` works locally first
3. Verify `package.json` has all dependencies

### Site not loading correctly
1. Clear browser cache (Ctrl+Shift+Delete)
2. Check console for errors (F12 → Console tab)
3. Verify all image URLs are accessible

---

## Support

For issues with:
- **Netlify**: [Netlify Docs](https://docs.netlify.com)
- **React**: [React Docs](https://react.dev)
- **Tailwind CSS**: [Tailwind Docs](https://tailwindcss.com/docs)

---

## Next Steps

1. ✅ Download & extract the project
2. ✅ Run `npm install`
3. ✅ Test locally with `npm run dev`
4. ✅ Deploy to Netlify
5. ✅ Configure your custom domain
6. ✅ Monitor analytics and conversions

Happy deploying! 🚀
