import { motion } from "framer-motion";
import { CheckCircle2, ArrowRight } from "lucide-react";
import { Button } from "@/components/ui/button";

const challenges = [
  {
    title: "Hydration Challenge",
    duration: "45 Days",
    description: "Build the habit of drinking enough water daily for clearer, plumper skin.",
    benefits: ["Daily Reminders", "Progress Tracking", "Milestone Badges"],
    color: "from-blue-500 to-cyan-400",
    bg: "bg-blue-50 border-blue-100",
  },
  {
    title: "Clear Skin Routine",
    duration: "21 Days",
    description: "A guided step-by-step program to reduce acne and inflammation naturally.",
    benefits: ["AM/PM Routines", "Product Guide", "Diet Tips"],
    color: "from-pink-500 to-rose-400",
    bg: "bg-pink-50 border-pink-100",
    featured: true,
  },
  {
    title: "Face Massage",
    duration: "14 Days",
    description: "Learn effective massage techniques to depuff and contour your face.",
    benefits: ["Video Guides", "5 Min/Day", "Relaxation"],
    color: "from-amber-500 to-orange-400",
    bg: "bg-amber-50 border-amber-100",
  },
];

export function Challenges() {
  return (
    <section id="challenges" className="py-24 bg-gradient-to-b from-[#FFFDF5] to-white">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <span className="text-primary font-bold tracking-wider text-sm uppercase mb-2 block">Free to Join</span>
          <h2 className="text-4xl md:text-5xl font-display font-bold text-foreground mb-4">
            Join Thousands in Our <br /> <span className="font-handwriting text-primary text-6xl relative -rotate-2 inline-block mt-2">Free Challenges</span>
          </h2>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-3 gap-8 items-start">
          {challenges.map((card, idx) => (
            <motion.div
              key={idx}
              initial={{ opacity: 0, y: 30 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ delay: idx * 0.1 }}
              className={`relative rounded-[2rem] p-8 border ${card.bg} ${card.featured ? 'shadow-2xl scale-105 z-10 bg-white' : 'shadow-lg bg-white/50'}`}
            >
              {card.featured && (
                <div className="absolute -top-4 left-1/2 -translate-x-1/2 bg-primary text-white px-4 py-1 rounded-full text-sm font-bold shadow-md">
                  Most Popular
                </div>
              )}
              
              <div className={`inline-block px-4 py-1 rounded-full text-xs font-bold text-white mb-6 bg-gradient-to-r ${card.color}`}>
                {card.duration}
              </div>
              
              <h3 className="text-2xl font-display font-bold text-gray-800 mb-4">{card.title}</h3>
              <p className="text-muted-foreground mb-8 min-h-[60px]">{card.description}</p>
              
              <div className="space-y-3 mb-8">
                {card.benefits.map((benefit, i) => (
                  <div key={i} className="flex items-center gap-3 text-sm font-medium text-gray-600">
                    <CheckCircle2 className="w-5 h-5 text-green-500" />
                    {benefit}
                  </div>
                ))}
              </div>

              <Button 
                className={`w-full rounded-xl py-6 text-base font-bold transition-all shadow-md hover:shadow-xl ${card.featured ? 'bg-primary hover:bg-primary/90 text-white' : 'bg-white text-gray-800 border-2 border-gray-100 hover:border-gray-300'}`}
                onClick={() => window.open("https://play.google.com/store/apps/details?id=com.masterfulcode.lumicareapp", "_blank")}
              >
                Start Free <ArrowRight className="ml-2 w-4 h-4" />
              </Button>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
  );
}
