import { motion } from "framer-motion";
import { ChevronDown } from "lucide-react";
import { useState } from "react";

const faqs = [
  {
    question: "Is Lumi Care really free?",
    answer: "Yes! Lumi Care is completely free to download and use. All core features including water tracking, AI acne detector, face massage guides, and community access are available at no cost."
  },
  {
    question: "How does the AI Acne Detector work?",
    answer: "Our AI-powered detector uses advanced image recognition to analyze your skin and identify acne-prone areas. Simply take a photo of your skin in good lighting, and we'll provide personalized insights and recommendations within seconds."
  },
  {
    question: "Do I need to be on a specific diet for the challenges?",
    answer: "No! Our challenges are designed to work with any lifestyle. We provide gentle guidance on nutrition, hydration, and exercise—but you're always in control. The goal is building sustainable habits, not restrictive diets."
  },
  {
    question: "Can I use Lumi Care without sharing my data?",
    answer: "Privacy is important to us. You have full control over what you share in the community. Your personal skin analysis and health data are encrypted and secure."
  },
  {
    question: "How long does it take to see results?",
    answer: "Many users report visible improvements within 2-3 weeks of consistent routine and hydration. However, skin health is individual. Some improvements are immediate (like better hydration), while others take time."
  },
  {
    question: "Can I use Lumi Care for conditions other than acne?",
    answer: "Yes! Lumi Care is designed for all skin types and concerns including dryness, sensitivity, aging, and general skin wellness. Our tips and challenges are holistic and benefit overall skin health."
  },
];

export function FAQ() {
  const [openIndex, setOpenIndex] = useState<number | null>(null);

  return (
    <section id="faq" className="py-24 bg-background">
      <div className="container mx-auto px-4 max-w-3xl">
        <motion.div 
          initial={{ opacity: 0, y: 20 }}
          whileInView={{ opacity: 1, y: 0 }}
          viewport={{ once: true }}
          className="text-center mb-16"
        >
          <h2 className="text-4xl md:text-5xl font-display font-bold text-foreground mb-4">
            Frequently Asked <span className="text-primary">Questions</span>
          </h2>
          <p className="text-lg text-muted-foreground">
            Everything you need to know about Lumi Care
          </p>
        </motion.div>

        <div className="space-y-4">
          {faqs.map((faq, idx) => (
            <motion.div
              key={idx}
              initial={{ opacity: 0, y: 10 }}
              whileInView={{ opacity: 1, y: 0 }}
              viewport={{ once: true }}
              transition={{ delay: idx * 0.05 }}
              className="rounded-2xl border border-gray-100 bg-white overflow-hidden shadow-sm hover:shadow-md transition-shadow"
            >
              <button
                onClick={() => setOpenIndex(openIndex === idx ? null : idx)}
                className="w-full flex items-center justify-between p-6 hover:bg-gray-50/50 transition-colors text-left"
              >
                <span className="text-lg font-bold text-foreground">{faq.question}</span>
                <motion.div
                  animate={{ rotate: openIndex === idx ? 180 : 0 }}
                  transition={{ duration: 0.3 }}
                >
                  <ChevronDown className="w-6 h-6 text-primary flex-shrink-0 ml-4" />
                </motion.div>
              </button>
              
              <motion.div
                initial={false}
                animate={{ height: openIndex === idx ? "auto" : 0 }}
                transition={{ duration: 0.3 }}
                className="overflow-hidden"
              >
                <div className="px-6 pb-6 text-muted-foreground leading-relaxed">
                  {faq.answer}
                </div>
              </motion.div>
            </motion.div>
          ))}
        </div>
      </div>
    </section>
  );
}
