import { Star } from "lucide-react";

const testimonials = [
  {
    quote: "My acne improved in 3 weeks just by following Lumi Car tips. The water reminders actually work!",
    author: "Jessica M.",
    role: "Verified User",
    rating: 5
  },
  {
    quote: "Hydration challenge changed my daily habits. I finally drink 2L a day without thinking about it.",
    author: "Sarah K.",
    role: "Verified User",
    rating: 5
  },
  {
    quote: "Finally a free app that actually helps without hiding everything behind a paywall. Love the community!",
    author: "Emily R.",
    role: "Verified User",
    rating: 5
  }
];

export function Testimonials() {
  return (
    <section id="testimonials" className="py-24 bg-secondary/20">
      <div className="container mx-auto px-4">
        <div className="text-center mb-16">
          <div className="flex justify-center gap-1 mb-4">
            {[1, 2, 3, 4, 5].map((i) => (
              <Star key={i} className="w-6 h-6 fill-yellow-400 text-yellow-400" />
            ))}
          </div>
          <h2 className="text-4xl font-display font-bold text-foreground">
            Trusted by <span className="text-primary">50,000+</span> Users
          </h2>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
          {testimonials.map((t, idx) => (
            <div key={idx} className="bg-white p-8 rounded-2xl shadow-sm border border-border/50 hover:shadow-md transition-shadow">
              <div className="flex gap-1 mb-4">
                {[...Array(t.rating)].map((_, i) => (
                  <Star key={i} className="w-4 h-4 fill-yellow-400 text-yellow-400" />
                ))}
              </div>
              <p className="text-lg text-gray-600 mb-6 italic leading-relaxed">"{t.quote}"</p>
              <div>
                <p className="font-bold text-gray-900">{t.author}</p>
                <p className="text-sm text-gray-500">{t.role}</p>
              </div>
            </div>
          ))}
        </div>
        
        <div className="mt-16 text-center">
           <p className="text-muted-foreground font-medium">Rated 4.8/5 on Google Play Store based on 2,000+ reviews</p>
        </div>
      </div>
    </section>
  );
}
